import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file


atp_tennis = read_csv_file('atp_tennis.csv')

# Fetching specific columns ('Original Odd_1', 'Original Odd_2', 'Updated Odd_1', 'Updated Odd_2') from the dataframe.
original_odd_1 = updated_odds_df['Original Odd_1']
original_odd_2 = updated_odds_df['Original Odd_2']
updated_odd_1 = updated_odds_df['Updated Odd_1']
updated_odd_2 = updated_odds_df['Updated Odd_2']

# Calculating the differences between updated and original odds for both odds 1 and 2.
difference_odd_1 = updated_odd_1 - original_odd_1
difference_odd_2 = updated_odd_2 - original_odd_2

# Calculating the percentage change for both sets of odds.
percentage_change_odd_1 = (difference_odd_1 / original_odd_1) * 100
percentage_change_odd_2 = (difference_odd_2 / original_odd_2) * 100

# Adding the calculated differences and percentage changes as new columns to the dataframe.
updated_odds_df['Difference Odd_1'] = difference_odd_1
updated_odds_df['Difference Odd_2'] = difference_odd_2
updated_odds_df['Percentage Change Odd_1'] = percentage_change_odd_1
updated_odds_df['Percentage Change Odd_2'] = percentage_change_odd_2

print(updated_odds_df)
pickle.dump(updated_odds_df,open("./ref_result/updated_odds_df.pkl","wb"))